//===============================================================================================
// Provides methods common to all wrappers
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

gWnd = null;
gDlgWnd = null;
gWndInterval = null;

kBottomBannerHeight = 15;
kBottomBorderHeight = 2;


//------------------------------------------------------------------------------------------------
function main()
	// Initialize the app after load
{
	document.onkeyup = onCheckForEsc;
		// Add a check for esc key
		
	// Resize the dialog area to fit the window
	onResize();
	window.onresize = onResize;
	
	if( window._main ) window._main();
		// Call a hook if present
		
	show(document.body);
}

//------------------------------------------------------------------------------------------------
function getArgs()
	//returns an array of command line arguments
{
	var a = document.getElementsByTagName( "APPLICATION" );	
	if( a.length == 0 ) return new Array();
	
	return a[0].commandLine.split( '&' );
}

//------------------------------------------------------------------------------------------------
function showOverlay()
{
	var l = document.getElementById("overlay");
	if(l)
	{
		l.style.height = getWindowHeight() +"px";
		show(l);
	}	
}

function hideOverlay()
{
	hideById( "overlay" );
}


//------------------------------------------------------------------------------------------------
function renderCommon( bNoCancel, spacerW, bkgndSrc )
	// Render common absolutely positioned elements including
	//		- top and bottom banners
	//		- watermark
	//		- overlay
{	
	if( !spacerW ) spacerW = 450;

	var logoPadW = 37;
	if( bNoCancel ) logoPadW = 15;
	
	// top banner border
	document.write( '<div class="topBannerBorder">&nbsp;</div>' );
	
	// top banner
	var s;	
	s =	'<div class="topBanner">';
	s +=		'<table width="100%" cols="4" cellspacing="0" cellpadding="0" border="0"><tbody>';
	s +=			'<tr style="padding-top:13px">';
	s +=				'<td align="left" valign="top" style="padding-left:15px;">';
	s +=					'<img src="ttaxLogo.gif" border="0"></td>';
	s +=				'<td><script>appendSpacer('+spacerW+')</script></td>';
	s +=				'<td align="right" valign="top" style="padding-top:20px;padding-right:'+logoPadW+'px">';
	s +=					'<img src="intuitLogo.gif" border="0"></td>';
	
	if( bNoCancel ) s+= '<td>&nbsp;</td>';
	else
	{
		s +=				'<td align="left" valign="top" style="padding-right:15px">';
		s +=					toClickableImg( "closeBtn.gif", "closeBtn_h.gif", "onAppExit()", "Close" );
		s +=  	      '</td>';
	}
		
	s +=			'</tr></tbody></table>';
	s +=  '</div>';
	document.write( s );
	s = null;
	
	// bottom banner and border
	document.write( '<div id="bottomBannerBorder">&nbsp;</div>' );
	document.write( '<div id="bottomBanner">&nbsp;</div>' );

	// overlay
	document.write( '<div id="overlay">&nbsp;</div>' );

	// Watermark, not implemented as a background style so we have greater control over its position
	if( !bkgndSrc ) bkgnd = "bkgnd.gif";
	document.write( '<img id="watermark" src="' + bkgndSrc + '" border="0">' );
}

//------------------------------------------------------------------------------------------------
// Event handlers
//------------------------------------------------------------------------------------------------

function onCheckForEsc()
	// Event handler to check for esc key click to close the wrapper
{
	if( window.event && 27==window.event.keyCode ) onAppExit();
}

//----------------------------------------------------------------------------
function onResize()
	// Position the watermark, clip to the left
{
	var winH = getWindowHeight();
	var winW = getWindowWidth();
	var x, y;
	
	var bdy = document.getElementById("dlgBody");
	if( bdy )
	{
		var offset = 92;
		if( window._watermarkOffset ) offset = window._watermarkOffset();
			// Call a hook if present

		x = bdy.offsetLeft - offset;
		var l = document.getElementById("watermark");
		if(l) l.style.left = x + "px";
	}

	// Resize the dialog area to fit the window
	var dlg = document.getElementById("dlg");
	if( dlg )
	{
		var h = winH - dlg.offsetTop - 10;
		dlg.style.height = h+"px";
	}		

	// Flush the rebate footer to bottom right of the window
	var e = document.getElementById("rebate");
	if( e )
	{
		y = winH - kBottomBannerHeight - kBottomBorderHeight - e.offsetHeight;
		x = winW - e.offsetWidth;
		e.style.top = y + "px";
		e.style.left = x + "px";
	}
	
	// Flush the options button to bottom of the window
	var e = document.getElementById("optionBtns");
	if( e )
	{
		y = winH - kBottomBannerHeight - kBottomBorderHeight - e.offsetHeight;
		e.style.top = y + "px";
	}
	
	// Flush the bottom banner to bottom of the window
	var e = document.getElementById("bottomBanner");
	if( e )
	{
		y = winH - kBottomBannerHeight;
		e.style.top = y + "px";
		
		e = document.getElementById("bottomBannerBorder");
		if( e )
		{
			y -= kBottomBorderHeight;
			e.style.top = y + "px";
		}		
	}
	
	if( window._onresize ) window._onresize();
		// Call a hook if present	
}

//------------------------------------------------------------------------------------------------
function onInstall()
	// Run setup, assumed to be at the root of the current drive
{
	// Get the current directory
	var shell = null;
	var curDir = null;
	
	try
	{
		shell = new ActiveXObject("WScript.Shell");
	}
	catch(e) {}
			
	try
	{
		if( shell )
		{
			var setupPath = "";
			
			// shell.CurrentDirectory only supported by WSH 5.6...IE 6
			if( shell.CurrentDirectory )
			{
				var curDir = shell.CurrentDirectory;
				if( curDir.length>=3 ) setupPath = curDir.substr( 0, 3 );
			}	

			if( setupPath.length == 0 ) setupPath = '\\';
			
			setupPath += "setup.exe";
			shell.run( setupPath );	
		}	
	}
	catch(e)
	{
		// failed, open windows explorer
		if( shell )
		{
			var cmd = "explorer ";
			cmd += shell.CurrentDirectory;			
			shell.run( cmd );	
		}
	}
	
	setTimeout( "onAppExit()", 2000 );
}

//------------------------------------------------------------------------------------------------
function onAppExit() { window.close() }


